@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    input[type="radio"] {
        display: none;
    }

    input[type="radio"]+label {
        display: inline-block;
        margin: 5px;
        padding: 5px 10px;
        background-color: #f8f9fa;
        border: 1px solid #ddd;
        border-radius: 5px;
        cursor: pointer;
    }

    label:hover {
        background-color: #f0f0f0;
    }

    input[type="radio"]:checked+label {
        background-color: #007bff;
        color: #fff;
        border-color: #007bff;
    }

    input[type="radio"]:hidden+.parking-label {
        background-color: #e9ecef;
        color: #000;
    }

    input[type="radio"]:checked+.parking-label {
        background-color: #007bff;
        color: #fff;
        border-color: #0056b3;
    }

    .custom-control-input {
        display: none;
    }

    .steps-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        padding: 0 15px;
    }

    .step-item {
        display: flex;
        align-items: center;
        position: relative;
        margin: 5px 0;
    }

    .step-circle {
        min-width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: #ddd;
        color: #555;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: bold;
        text-decoration: none;
        z-index: 2;
    }

    .step-circle.active {
        background-color: #007bff;
        color: white;
    }

    .step-label {
        margin: 0 8px;
        white-space: nowrap;
        font-size: 14px;
    }

    .step-line {
        height: 4px;
        background-color: #ddd;
        flex: 1;
        min-width: 20px;
        max-width: 50px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .steps-container {
            flex-direction: column;
            align-items: flex-start;
            max-width: 100%;
        }

        .step-item {
            width: 100%;
            margin-bottom: 15px;
        }

        .step-line {
            position: absolute;
            left: 15px;
            top: 30px;
            width: 4px;
            height: 20px;
            min-width: 4px;
        }

        .step-label {
            margin-left: 15px;
        }

        .step-item:last-child .step-line {
            display: none;
        }
    }

    /* Medium screens */
    @media (min-width: 769px) and (max-width: 991px) {
        .step-label {
            font-size: 12px;
        }

        .step-line {
            min-width: 15px;
            max-width: 30px;
        }
    }

    /* Responsive for floor plan cards */
    @media (max-width: 767.98px) {
        #floor-plans-container .card-body .row.g-3.align-items-start>div[class^='col-'] {
            flex: 0 0 100%;
            max-width: 100%;
        }

        .back-preview-image {
            max-width: 100% !important;
            height: 100px !important;
        }
    }

    @media (max-width: 575.98px) {
        .steps-container {
            flex-direction: column;
            align-items: flex-start;
        }

        .step-item {
            width: 100%;
        }

        .step-label {
            margin-left: 10px;
        }
    }

    @media (min-width: 768px) {
        #floor-plans-container .row.small.text-muted>div {
            flex: 0 0 33.3333%;
            max-width: 33.3333%;
        }
    }

    @media (max-width: 767.98px) {
        #floor-plans-container .row.small.text-muted>div {
            flex: 0 0 100%;
            max-width: 100%;
        }

        .back-preview-image {
            max-width: 100% !important;
            height: 100px !important;
        }
    }
</style>
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class="row justify-content-center mt-3">
    <div class="col-md-12">
        <form class="" id="property-form"
            action="{{ isset($property->id) ? route('agent.properties.builder_store_step_4', ['id' => $property->id]) : route('agent.properties.builder_store_step_4') }}"
            method="POST" enctype="multipart/form-data">
            {{ csrf_field() }}
            <div class="row card">
                <div class="col-lg-12">
                    <div class="">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6>{{ __('Property Images') }}</h6>
                        </div>
                        <style>
                            body {
                                background-color: #f8f9fa;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                padding: 20px;
                            }

                            .container {
                                max-width: 1000px;
                            }

                            .card {
                                border-radius: 10px;
                                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                                margin-bottom: 30px;
                            }

                            .card-header {
                                background: linear-gradient(135deg, #6c5ce7, #8e44ad);
                                color: white;
                                font-weight: 600;
                            }

                            .gallery-img {
                                position: relative;
                                margin-bottom: 20px;
                                overflow: hidden;
                                border-radius: 8px;
                                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
                            }

                            .gallery-img img {
                                width: 100%;
                                height: 200px;
                                object-fit: cover;
                            }

                            .remove-img {
                                position: absolute;
                                top: 10px;
                                right: 10px;
                                background: rgba(255, 0, 0, 0.7);
                                color: white;
                                width: 30px;
                                height: 30px;
                                border-radius: 50%;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                cursor: pointer;
                            }

                            .upload-area {
                                border: 2px dashed #6c5ce7;
                                border-radius: 10px;
                                padding: 30px;
                                text-align: center;
                                background-color: rgba(108, 92, 231, 0.05);
                                cursor: pointer;
                            }

                            .upload-icon {
                                font-size: 50px;
                                color: #6c5ce7;
                                margin-bottom: 15px;
                            }

                            .btn-primary {
                                background: linear-gradient(135deg, #6c5ce7, #8e44ad);
                                border: none;
                            }

                            .alert {
                                border-radius: 8px;
                                border: none;
                            }

                            .progress {
                                height: 8px;
                                margin-top: 10px;
                                border-radius: 4px;
                            }

                            .instructions {
                                background-color: #f8f9fa;
                                border-left: 4px solid #6c5ce7;
                                padding: 15px;
                                margin-bottom: 20px;
                            }
                        </style>

                                <div class="row justify-content-center">
                                    <div class="col-lg-10">
                                        <div class="card">
                                            <div class="card-header text-center">
                                                <h3 class="mb-0">Image Upload System</h3>
                                                <p class="mb-0 mt-2">With Advanced Error Handling</p>
                                            </div>
                                            <div class="card-body">
                                                <div class="instructions">
                                                    <h5>Upload Instructions:</h5>
                                                    <p class="mb-1">- Supported formats: JPG, JPEG, PNG, SVG</p>
                                                    <p class="mb-1">- Maximum file size: 5MB</p>
                                                    <p class="mb-0">- Minimum 4 images required per property</p>
                                                </div>

                                                <div class="d-flex justify-content-between align-items-center mb-4">
                                                    <h4 class="mb-0">Property Images</h4>
                                                    <button class="btn btn-primary set-gallery">
                                                        <i class="fas fa-sync-alt me-2"></i>Refresh Gallery
                                                    </button>
                                                </div>

                                                <div class="alert alert-danger d-none" id="error-message"></div>
                                                <div class="alert alert-success d-none" id="success-message"></div>

                                                <div class="selected-image mb-4">
                                                    <div class="row justify-content-center">
                                                        <div class="col-12 text-center py-4">
                                                            <h5 class="text-muted">No images found for this property</h5>
                                                            <p class="text-muted">Click the button below to upload images</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="upload-area mb-4" id="uploadTrigger">
                                                    <div class="upload-icon">
                                                        <i class="fas fa-cloud-upload-alt"></i>
                                                    </div>
                                                    <h4>Drag & Drop Images Here</h4>
                                                    <p class="text-muted">or click to browse your files</p>
                                                    <p class="text-muted">(You can select multiple images)</p>
                                                    <input type="file" id="property_upload_gallery_edit" multiple accept=".jpg,.jpeg,.png,.svg" class="d-none">
                                                </div>

                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <span id="selectedCount">0 images selected</span>
                                                        <div class="progress d-none" id="uploadProgress">
                                                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%"></div>
                                                        </div>
                                                    </div>
                                                    <button class="btn btn-primary" id="uploadButton" disabled>
                                                        <i class="fas fa-upload me-2"></i>Upload Images
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                    <div class="">

                        <div class="card-body">
                            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Floor Plan Name') }}</h6>
                            </div>
                            <div id="floor-plans-container">
                                @foreach ($floor_plans as $key => $f_plan)
                                <div class="card my-3 shadow-sm">
                                    <div class="card-body">
                                        <div class="row align-items-start flex-wrap">
                                            <div class="col-12 col-md-8">
                                                <div class="row gx-2 flex-wrap">
                                                    <div class="col-12 col-md-6 mb-3">
                                                        <label for="floor_name_{{ $key }}" class="form-label">Floor Plan Name</label>
                                                        <input type="text" class="form-control" name="floor_name[]" id="floor_name_{{ $key }}" value="{{ $f_plan->floor_name }}" placeholder="Enter Plan Floor Name">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="row">
                                                    <div class="col-12 mb-2">
                                                        <div class="back-preview-image mb-2 mx-auto mx-md-0"
                                                            style="background-image: url({{ $f_plan->photo ? asset('assets/images/' . $f_plan->photo) . '?t=' . time() : asset('assets/images/placeholder.jpg') }}); height: 150px; width: 100%; max-width: 350px; background-size: cover; background-position: center; border-radius: 8px;">
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <input type="hidden" name="floor_id[]" value="{{ $f_plan->id }}">
                                                        <div class="form-group">
                                                            <input type="file" name="floor_images[]" class="form-control" @if (!$f_plan->photo) required @endif>
                                                            @if (!$f_plan->photo)
                                                            @error("floor_images.$key")
                                                            <small class="text-danger">{{ $message }}</small>
                                                            @enderror
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-center my-3">
                        <a href="{{ route('agent.properties.step_3', $property->id ?? null) }}" id="back-btn"
                            class="btn btn-secondary w-25">{{ __('Back') }}</a>
                        <button type="submit" id="submit-btn"
                            class="btn btn-primary w-25 mx-2">{{ __('Save') }}</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
@section('scripts')
<!-- <script src="{{ asset('assets/front/js/image_gallary.js') }}"></script> -->
 <script>
    $(document).ready(function() {
        const mainurl = window.location.origin;
        let selectedFiles = [];
        
        // Handle file selection
        $('#property_upload_gallery_edit').change(function(e) {
            selectedFiles = Array.from(e.target.files);
            updateSelectedCount();
            validateFiles();
        });
        
        // Click on upload area triggers file input
        $('#uploadTrigger').click(function() {
            $('#property_upload_gallery_edit').click();
        });
        
        // Drag and drop functionality
        $('#uploadTrigger').on('dragover', function(e) {
            e.preventDefault();
            $(this).addClass('bg-light');
        });
        
        $('#uploadTrigger').on('dragleave', function(e) {
            e.preventDefault();
            $(this).removeClass('bg-light');
        });
        
        $('#uploadTrigger').on('drop', function(e) {
            e.preventDefault();
            $(this).removeClass('bg-light');
            
            const files = e.originalEvent.dataTransfer.files;
            selectedFiles = Array.from(files);
            updateSelectedCount();
            validateFiles();
        });
        
        // Update selected files count
        function updateSelectedCount() {
            const count = selectedFiles.length;
            $('#selectedCount').text(`${count} image${count !== 1 ? 's' : ''} selected`);
            
            if (count > 0) {
                $('#uploadButton').prop('disabled', false);
            } else {
                $('#uploadButton').prop('disabled', true);
            }
        }
        
        // Validate selected files
        function validateFiles() {
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/svg+xml'];
            const maxSize = 5 * 1024 * 1024; // 5MB
            
            let errorMessages = [];
            
            selectedFiles.forEach(file => {
                // Check file type
                if (!allowedTypes.includes(file.type)) {
                    errorMessages.push(`"${file.name}" is not a supported file type. Only JPG, JPEG, PNG, and SVG files are allowed.`);
                }
                
                // Check file size
                if (file.size > maxSize) {
                    errorMessages.push(`"${file.name}" exceeds the maximum file size of 5MB.`);
                }
            });
            
            if (errorMessages.length > 0) {
                showError(errorMessages.join('<br>'));
                $('#uploadButton').prop('disabled', true);
            } else {
                hideError();
                if (selectedFiles.length > 0) {
                    $('#uploadButton').prop('disabled', false);
                }
            }
        }
        
        // Upload images
        $('#uploadButton').click(function() {
            if (selectedFiles.length === 0) {
                showError('Please select at least one image to upload.');
                return;
            }
            
            // Create FormData object
            const formData = new FormData();
            selectedFiles.forEach(file => {
                formData.append('gallery[]', file);
            });
            formData.append('property_id', 123); // Example property ID
            
            // Show progress bar
            $('#uploadProgress').removeClass('d-none');
            $('#uploadButton').prop('disabled', true);
            
            // AJAX upload with progress
            $.ajax({
                url: mainurl + '/seller/gallery/store',
                method: "POST",
                data: formData,
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                xhr: function() {
                    const xhr = new window.XMLHttpRequest();
                    xhr.upload.addEventListener("progress", function(evt) {
                        if (evt.lengthComputable) {
                            const percentComplete = (evt.loaded / evt.total) * 100;
                            $('#uploadProgress .progress-bar').css('width', percentComplete + '%');
                        }
                    }, false);
                    return xhr;
                },
                success: function(data) {
                    // Handle success response
                    uploadComplete(data);
                },
                error: function(xhr, status, error) {
                    // Handle error
                    uploadError(xhr, status, error);
                }
            });
        });
        
        // Handle upload completion
        function uploadComplete(data) {
            $('#uploadProgress').addClass('d-none');
            $('#uploadProgress .progress-bar').css('width', '0%');
            $('#uploadButton').prop('disabled', false);
            
            if (data && data.success) {
                showSuccess(data.message || `Successfully uploaded ${data.images.length} image(s)!`);
                updateGallery(data.images);
                selectedFiles = [];
                updateSelectedCount();
            } else {
                showError(data.message || 'No images were uploaded. Please try again.');
            }
        }
        
        // Handle upload error
        function uploadError(xhr, status, error) {
            $('#uploadProgress').addClass('d-none');
            $('#uploadProgress .progress-bar').css('width', '0%');
            $('#uploadButton').prop('disabled', false);
            
            let errorMsg = 'An error occurred while uploading the images.';
            
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMsg = xhr.responseJSON.message;
            } else if (xhr.status === 413) {
                errorMsg = 'File size too large. Please upload files smaller than 5MB.';
            } else if (xhr.status === 415) {
                errorMsg = 'Unsupported file type. Please upload only JPG, JPEG, PNG, or SVG files.';
            }
            
            showError(errorMsg);
        }
        
        // Update gallery display
        function updateGallery(images) {
            if (!images || images.length === 0) {
                $('.selected-image .row').html(`
                    <div class="col-12 text-center py-4">
                        <h5 class="text-muted">No images found for this property</h5>
                        <p class="text-muted">Click the button below to upload images</p>
                    </div>
                `);
                return;
            }
            
            let html = '';
            images.forEach(img => {
                html += `
                <div class="col-sm-6 col-md-4 col-lg-3">
                    <div class="img gallery-img">
                        <span class="remove-img"><i class="fas fa-times"></i>
                            <input type="hidden" value="${img.id}">
                        </span>
                        <a href="${mainurl}/assets/images/${img.photo}" target="_blank">
                            <img src="${mainurl}/assets/images/${img.photo}" alt="gallery image">
                        </a>
                        <div class="image-info">${img.photo}</div>
                    </div>
                </div>`;
            });
            
            $('.selected-image .row').html(html);
        }
        
        // Show error message
        function showError(message) {
            $('#error-message').html(message).removeClass('d-none');
            $('#success-message').addClass('d-none');
        }
        
        // Hide error message
        function hideError() {
            $('#error-message').addClass('d-none');
        }
        
        // Show success message
        function showSuccess(message) {
            $('#success-message').text(message).removeClass('d-none');
            $('#error-message').addClass('d-none');
            
            // Auto hide after 3 seconds
            setTimeout(hideSuccess, 3000);
        }
        
        // Hide success message
        function hideSuccess() {
            $('#success-message').addClass('d-none');
        }
        
        // Refresh gallery
        $('.set-gallery').click(function() {
            // In a real implementation, this would fetch the gallery from the server
            $.ajax({
                type: "GET",
                url: mainurl + '/seller/gallery/show',
                data: { id: 123 }, // Example property ID
                success: function(data) {
                    if (data.success) {
                        updateGallery(data.images);
                        showSuccess('Gallery refreshed successfully!');
                    } else {
                        showError(data.message || 'Failed to load gallery.');
                    }
                },
                error: function() {
                    showError('An error occurred while loading the gallery.');
                }
            });
        });
        
        // Remove image
        $(document).on('click', '.remove-img', function() {
            const id = $(this).find('input[type=hidden]').val();
            $(this).closest('.col-sm-6').remove();
            
            // AJAX call to delete the image
            $.ajax({
                type: "GET",
                url: mainurl + '/seller/gallery/delete',
                data: { id: id },
                success: function(data) {
                    if (data.success) {
                        showSuccess('Image removed successfully!');
                    } else {
                        showError(data.message || 'Failed to remove image.');
                    }
                },
                error: function() {
                    showError('An error occurred while removing the image.');
                }
            });
        });
    });
    </script>
<script>
    var mainurl = "{{ url('/') }}";

    $(document).ready(function() {
        // Handle the close button (×) click
        $('#setgallery .close').on('click', function() {
            $('#setgallery').modal('hide');
            cleanupModal();
        });

        // Handle the done button click
        $('.upload-done').on('click', function(e) {
            var uploadedImagesCount = $('.gallery-images .gallery-img').length;
            if (uploadedImagesCount < 4) {
                alert('Please upload at least 4 images before proceeding.');
                e.preventDefault();
            } else {
                $('#setgallery').modal('hide');
                cleanupModal();
            }
        });

        // Common function to clean up modal
        function cleanupModal() {
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();
            $('#form-gallery')[0].reset();
            $('#property_upload_gallery_edit').val('');
        }

        // Form submission validation
        $('#property-form').on('submit', function(e) {
            var uploadedImagesCount = $('.gallery-images .gallery-img').length;
            if (uploadedImagesCount < 4) {
                $('#error-message').show();
                e.preventDefault();
            } else {
                $('#error-message').hide();
            }
        });
    });
</script>
@endsection